function [sigcv,n1cv,n2cv] = critcv(x,p1,p2,d,r)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.7
% File: critcv.m
%
% This function gives the sum of squares of the cross-validation criteria.
%
% INPUT:
% x  = data 
% p1 = AR order of first regime
% p2 = AR order of second regime
% d  = delay
% r  = threshold
%
% OUTPUT:
% sigcv =  the value (1/n)*sum(a.^2), where a the vector with the
%          predictive residuals of the cross-validation
% n1cv  =  number of observations in first regime
% n2cv  =  number of observations in second regime
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = length(x);
h = max([p1 p2 d]) + 1;
ecv = zeros(1,n);

Y1 = [];
X1 = [];
Y2 = [];
X2 = [];
n1cv = 0;
n2cv = 0;

for i = h : n
    if x(i - d) <= r
       n1cv = n1cv + 1;
       Y1 = [Y1;x(i)];
       X1 = [X1;[1 x((i-1):-1:(i-p1))]];
    else
       n2cv = n2cv + 1;
       Y2 = [Y2;x(i)];
       X2 = [X2;[1 x((i-1):-1:(i-p2))]];
    end
end

i1 = 1 : n1cv;
i2 = 1 : n2cv;

for j = 1 : n1cv
    aux    = inv(X1(i1~=j,:)' * X1(i1~=j,:)) * X1(i1~=j,:)' * Y1(i1~=j);
    xpre   = X1(j,:) * aux;
    ecv(j) = Y1(j) - xpre;
end

for j = 1 : n2cv
    aux  = inv(X2(i2~=j,:)' * X2(i2~=j,:)) * X2(i2~=j,:)' * Y2(i2~=j,:);
    xpre = X2(j,:) * aux;
    ecv(n1cv+j) = Y2(j) - xpre;
end

sigcv = sum(ecv.^2)/n;
